/*
 * Decompiled with CFR 0.152.
 */
package filenet.sim.toolkit.viewer.statistics;

import filenet.sim.toolkit.viewer.VWSIMAnimatorDataModel;
import filenet.sim.toolkit.viewer.animation.VWSIMAnimationController;
import filenet.sim.toolkit.viewer.statistics.IVWSIMStatPanel;
import filenet.sim.toolkit.viewer.statistics.VWSIMSimulationStatTable;
import filenet.sim.toolkit.viewer.statistics.VWSIMSimulationStatTableModel;
import filenet.sim.toolkit.viewer.statistics.VWSIMStatisticsPanel;
import java.awt.Frame;
import java.util.Vector;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class VWSIMSimulationStatPanel
extends JScrollPane
implements ChangeListener,
IVWSIMStatPanel {
    private VWSIMStatisticsPanel m_statisticsPanel = null;
    private VWSIMSimulationStatTableModel m_tableModel = null;
    private VWSIMSimulationStatTable m_table = null;
    private VWSIMAnimationController m_animationController = null;
    private VWSIMAnimatorDataModel m_animatorDataModel = null;
    private Vector m_itemListeners = new Vector();
    protected Frame m_parentFrame = null;

    VWSIMSimulationStatPanel(Frame parentFrame, VWSIMStatisticsPanel statisticsPanel, VWSIMAnimatorDataModel dataModel, VWSIMAnimationController animationController) {
        this.m_parentFrame = parentFrame;
        this.m_statisticsPanel = statisticsPanel;
        this.m_animationController = animationController;
        this.m_animatorDataModel = dataModel;
    }

    public void initialize() {
        if (this.m_animatorDataModel == null || this.m_animatorDataModel.getInitState() != 6) {
            return;
        }
        this.m_tableModel = new VWSIMSimulationStatTableModel(this.m_animationController);
        this.m_table = new VWSIMSimulationStatTable(this.m_parentFrame, this, this.m_tableModel);
        this.m_tableModel.initData();
        this.add(this.m_table);
        this.setViewportView(this.m_table);
    }

    public void stateChanged(ChangeEvent e) {
        if (e.getSource() instanceof JTabbedPane && this.m_table != null) {
            JTabbedPane tabbedPane = (JTabbedPane)e.getSource();
            if (tabbedPane.getSelectedComponent() == this) {
                this.m_table.tabSelected(true);
            } else {
                this.m_table.tabSelected(false);
            }
        }
    }

    public void updateInfo() {
        this.m_tableModel.fireTableDataChanged();
    }

    public void releaseResources() {
        this.m_statisticsPanel = null;
        if (this.m_tableModel != null) {
            this.m_tableModel.releaseResources();
            this.m_tableModel = null;
        }
        if (this.m_table != null) {
            this.m_table.releaseResources();
            this.m_table = null;
        }
        this.m_animationController = null;
        this.m_animatorDataModel = null;
        if (this.m_itemListeners != null) {
            this.m_itemListeners.removeAllElements();
            this.m_itemListeners = null;
        }
        this.removeAll();
        this.m_parentFrame = null;
    }
}

